"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WATCH_STATUS = exports.WATCH_EXAMPLES = exports.WATCH_ACTION_STATUS = exports.ROUTE_PATH = exports.PERMISSIONS_FOR_ACCESS = exports.NO_MULTITENANCY_TENANT = exports.MAX_DOC_COUNT_SEARCH = exports.INDEX = exports.ES_SCROLL_SETTINGS = exports.DEFAULT_DATEFIELD_RANGE_QUERY_LT = exports.DEFAULT_DATEFIELD_RANGE_QUERY_GTE = exports.DEFAULT_DATEFIELD = exports.BASE_URI = exports.APP_NAME = exports.APP_DESCRIPTION = void 0;
/* eslint-disable @kbn/eslint/require-license-header */
const APP_NAME = 'searchguard-signals';
exports.APP_NAME = APP_NAME;
const APP_DESCRIPTION = 'Search Guard Signals';
exports.APP_DESCRIPTION = APP_DESCRIPTION;
const INDEX = {
  ALERTS: '.signals_log_*',
  ALERT_DOC_TYPE: '_doc'
};
exports.INDEX = INDEX;
const BASE_URI = `/api/${APP_NAME}`;
exports.BASE_URI = BASE_URI;
const ROUTE_PATH = {
  WATCH: `${BASE_URI}/watch`,
  WATCHES: `${BASE_URI}/watches`,
  ACCOUNT: `${BASE_URI}/account`,
  ACCOUNTS: `${BASE_URI}/accounts`,
  WATCH_EXECUTE: `${BASE_URI}/watch/_execute`,
  WATCH_EXECUTE_GRAPH: `${BASE_URI}/watch/_execute_graph`,
  ALERT: `${BASE_URI}/alert`,
  ALERTS: `${BASE_URI}/alerts`,
  SEARCH: `${BASE_URI}/_search`,
  MAPPINGS: `${BASE_URI}/_mappings`,
  INDICES: `${BASE_URI}/_indices`,
  ALIASES: `${BASE_URI}/_aliases`,
  SEARCHGUARD: {
    SIGNALS_HAS_PERMISSIONS: `${BASE_URI}/searchguard/signals_has_permissions`
  }
};
exports.ROUTE_PATH = ROUTE_PATH;
const MAX_DOC_COUNT_SEARCH = 800;
exports.MAX_DOC_COUNT_SEARCH = MAX_DOC_COUNT_SEARCH;
const DEFAULT_DATEFIELD = 'execution_end';
exports.DEFAULT_DATEFIELD = DEFAULT_DATEFIELD;
const DEFAULT_DATEFIELD_RANGE_QUERY_GTE = 'now-30m';
exports.DEFAULT_DATEFIELD_RANGE_QUERY_GTE = DEFAULT_DATEFIELD_RANGE_QUERY_GTE;
const DEFAULT_DATEFIELD_RANGE_QUERY_LT = 'now';
exports.DEFAULT_DATEFIELD_RANGE_QUERY_LT = DEFAULT_DATEFIELD_RANGE_QUERY_LT;
const ES_SCROLL_SETTINGS = {
  KEEPALIVE: '25s',
  PAGE_SIZE: 10
};
exports.ES_SCROLL_SETTINGS = ES_SCROLL_SETTINGS;
const WATCH_EXAMPLES = {
  AVG_TICKET_PRICE: 'avg_ticket_price',
  BAD_WEATHER: 'bad_weather',
  CHANGE_IN_MEMORY: 'change_in_memory',
  MAX_MEMORY: 'max_memory',
  MEMORY_USAGE: 'memory_usage',
  MIN_PRODUCT_PRICE: 'min_product_price'
};
exports.WATCH_EXAMPLES = WATCH_EXAMPLES;
const NO_MULTITENANCY_TENANT = '_main';
exports.NO_MULTITENANCY_TENANT = NO_MULTITENANCY_TENANT;
const WATCH_STATUS = {
  EXECUTION_FAILED: 'EXECUTION_FAILED',
  ACTION_EXECUTED: 'ACTION_EXECUTED',
  NO_ACTION: 'NO_ACTION',
  ACKED: 'ACKED'
};
exports.WATCH_STATUS = WATCH_STATUS;
const WATCH_ACTION_STATUS = {
  ACTION_FAILED: 'ACTION_FAILED',
  ACTION_THROTTLED: 'ACTION_THROTTLED',
  ACTION_EXECUTED: 'ACTION_EXECUTED',
  ACKED: 'ACKED'
};
exports.WATCH_ACTION_STATUS = WATCH_ACTION_STATUS;
const PERMISSIONS_FOR_ACCESS = ['cluster:admin:searchguard:tenant:signals:watch/get'];
exports.PERMISSIONS_FOR_ACCESS = PERMISSIONS_FOR_ACCESS;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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